/* Author: Helen Wollan <h.e.wollan@sms.ed.ac.uk>
 * Updated: Thurs Sept 02 2004 by Helen Wollan
 * Copyright: (c) 2003, AIAI, University of Edinburgh
 */

package ix.ip2.map;

import java.awt.Color;
import java.text.*;
import java.util.*;
import java.lang.reflect.Array;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.Component;

import com.bbn.openmap.Layer;
import com.bbn.openmap.*;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.omGraphics.event.*;
import com.bbn.openmap.event.*;

import ix.util.Util;
import ix.util.Parameters;
import ix.iface.util.CatchingActionListener;
import ix.icore.domain.PatternAssignment;

import ix.util.*;
import ix.icore.domain.*;
import ix.iface.util.*;

import ix.icore.process.event.*; 
import ix.icore.IXAgent;
import ix.util.lisp.*;
import ix.ip2.*;

public class IxStatusLayer extends OMGraphicHandlerLayer implements ProcessStatusListener {

    private OMGraphicList omgraphics; 
    private Map map;
    private Projection proj;
    private Ip2 agent;
    private Hashtable statushash, sectorlist;
    private Color sectorColor = Color.black;
    private int lineType = OMGraphic.LINETYPE_STRAIGHT; // OMGraphic.LINETYPE_STRAIGHT
    private Color done = Color.green;
    private Color incomplete = Color.red;
    private Color partialcomplete = Color.orange;
    private Color complete = Color.yellow;
    

    public IxStatusLayer() {
        super();       
		omgraphics = (OMGraphicList)getList();
		
		//initialise the hashtables to keep track of the various details of the sector
		statushash = new Hashtable();
		sectorlist = new Hashtable();
		
		agent = (Ip2) IXAgent.getAgent();
		(agent.getModelManager()).addProcessStatusListener(this);
    }

	// initialise the properties of the layer
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        
    }
    
	// render the omgraphics on the map
    public void paint(java.awt.Graphics g) {
        omgraphics.render(g);
    }
    
	// repaint the omgraphics when the projection is changed by the user
    public void projectionChanged(ProjectionEvent pe) {
        Projection oldProj = proj;
        proj = setProjection(pe);
        if (proj != null) {
            getList().generate(proj);
            repaint();
        }
        else
            proj = oldProj;
    
        fireStatusUpdate(LayerStatusEvent.FINISH_WORKING);
    }   

	// return the list of the omgraphics
    public OMGraphicList getList() {
        OMGraphicList list = super.getList();
        if (list == null) {
            list = new OMGraphicList();
            super.setList(list);
        }
        return list;
    }

	// remove all data contained in the sector layer
    public void reset(){
        // clear all hashtables:
        sectorlist.clear();
        statushash.clear();
    }

    // ProcessStatusListener 
    // This reads in the constraints whenever they are changed and performs the appropriate
    // operations on them.

    public void stateChange(ProcessStatusEvent event, Map delta) {
    	map = delta;
    	String sector;
    	String name;

		try{
	    	for (Iterator i = delta.entrySet().iterator(); i.hasNext();) {
				Map.Entry e = (Map.Entry)i.next();
				LList pattern = (LList)e.getKey(); 
	
				LList property = ((LList)pattern.clone()).delete(pattern.get(1));
				
				if( ((property.get(0)).toString()).equals("sector") ) {
					Vector points = new Vector();
					sector = (pattern.get(1)).toString(); // the sector name
		    		OMPoly path = null;
		    		LList value = (LList) e.getValue();
		    		float pointsF[] = new float[value.size()*2];
					
					// reading through the points and adding them to a float[] array and a 
					// vector for internal storage.
		    		for(int x=0;x<value.size();x++){
						LList point = (LList) value.get(x);
						pointsF[2*x] = Float.parseFloat((point.get(0)).toString());
						pointsF[2*x+1] = Float.parseFloat((point.get(1)).toString());
						points.add(new Float((point.get(0)).toString()));
		    		}
					
					//check if the sector already exists and if so, modify the location of the OMPoly
		    		if (sectorlist.containsKey(sector)) {
						path = (OMPoly) sectorlist.get(sector);
						path.setLocation(pointsF,OMGraphic.DECIMAL_DEGREES);
		    		} else {
		    			// the sector is new so create a new OMPoly
						path = new OMPoly(pointsF,OMGraphic.DECIMAL_DEGREES,lineType);
						path.setLinePaint(sectorColor);	
						omgraphics.add(path);
						// add the OMPoly to the hashtable for storage
						sectorlist.put(sector,path);
					}				
				} else if( ((property.get(0)).toString()).equals("status") ) {
	    			// the constraint is the status of the sector (a percentage complete)
	    			// put the status in a hashtable with the sector name as the key
	    			// set the fill paint of the sectors according to the status
	    			sector = (pattern.get(1)).toString();
	    			Double svalue = (Double) e.getValue();
	    			statushash.put(sector, svalue);
	    			OMPoly sectorpoly = (OMPoly) sectorlist.get(sector);
	    			if (svalue.compareTo(new Double(33)) <= 0) {
	    				sectorpoly.setFillPaint(incomplete);
	    			} else if (svalue.compareTo(new Double(66)) <= 0) {
	    				sectorpoly.setFillPaint(partialcomplete);
	    			} else if (svalue.compareTo(new Double(99)) <= 0) {
	    				sectorpoly.setFillPaint(complete);
	    			} else {
	    				sectorpoly.setFillPaint(done);
	    			}
	    			getList().generate(proj);
					repaint();
				}
	    			
	    	}
		} catch(Exception exception) {
			System.err.println("Syntax error in status "); 
			exception.printStackTrace();
		}
		
    }

	// method to deal with constraints being deleted from IX.
    public void stateDeletion(ProcessStatusEvent event, java.util.Map delta){
		for (Iterator i = delta.entrySet().iterator(); i.hasNext();) {
		    Map.Entry e = (Map.Entry)i.next();
	    	LList pattern = (LList)e.getKey(); 
	    	LList property = ((LList)pattern.clone()).delete(pattern.get(1));
	    	if (((property.get(0)).toString()).equals("status")) {
	    		// Just the status was deleted - remove from the hash table
		    	if (statushash.containsKey(pattern.get(1))) {
	    			statushash.remove(pattern.get(1));
	    			OMPoly poly = (OMPoly) sectorlist.get(pattern.get(1));
	    			poly.setFillPaint(null);
	    		}	
	    	}
    	}
    }

    public void newBindings(ProcessStatusEvent e, java.util.Map bindings){}
    public void statusUpdate(ProcessStatusEvent e){}
    
}